package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.objects.characteristics.Intelligence;
import com.hero.ui.dialog.ModifierDialog;
import com.hero.ui.dialog.RequiresSkillRollDialog;
import com.hero.util.Constants;
import com.hero.util.Rounder;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class RequiresSkillRoll extends Modifier {
	public static final int backgroundType = 1;

	public static final int charType = 2;

	public static final int perType = 3;

	public static final int skillType = 0;

	private static String xmlID = "REQUIRESASKILLROLL";

	private double backgroundSkill;

	private int characteristic;

	private int characteristic2;

	private boolean refreshOnUpdate;

	private double roll10;

	private double roll11;

	private double roll12;

	private double roll13;

	private double roll14;

	private double roll15;

	private double roll8;

	private double roll9;

	private String rollAlias = "Skill";

	private String rollAlias2 = "Skill";

	private int type;

	private int type2;

	public RequiresSkillRoll(Element root) {
		super(root, RequiresSkillRoll.xmlID);
	}

	public ArrayList<Adder> getAvailableAdders() {
		if ((getSelectedOption() == null)
				|| getSelectedOption().getXMLID().equals("BASICRSR")
				|| getSelectedOption().getXMLID().equals("TWOROLLS")) {
			return availableAdders;
		} else {
			ArrayList<Adder> subAdders = (ArrayList<Adder>) availableAdders
					.clone();
			for (int i = subAdders.size() - 1; i >= 0; i--) {
				Adder ad = subAdders.get(i);
				if (ad.getXMLID().equals("VARIABLERSR")
						|| ad.getXMLID().equals("SKILLVSSKILL")) {
					subAdders.remove(i);
				}
			}
			return subAdders;
		}
	}

	public double getBaseCost() {
		setSelectedOption(getSelectedOption());
		double val = super.getBaseCost();
		if ((getSelectedOption() == null)
				|| getSelectedOption().getXMLID().equals("BASICRSR")) {
			if (type == RequiresSkillRoll.skillType) {
				return val;
			} else if (type == RequiresSkillRoll.backgroundType) {
				val = val + backgroundSkill;
				return val;
			} else if (type == RequiresSkillRoll.perType) {
				if (HeroDesigner.getActiveHero() != null) {
					Intelligence intel = (Intelligence) HeroDesigner
							.getActiveHero().getCharacteristic(Constants.INT);
					if (intel != null) {
						val = getRollAdjustment(intel.getPrimaryPERRoll());
					} else {
						val = roll11;
					}
				} else {
					val = roll11;
				}
			} else {
				if (HeroDesigner.getActiveHero() != null) {
					Characteristic chara = HeroDesigner.getActiveHero()
							.getCharacteristic(characteristic);
					if (chara != null) {
						val = getRollAdjustment((int) (9 + Rounder
								.roundHalfUp(chara.getPrimaryValue() / 5d)));
					} else {
						val = roll11;
					}
				} else {
					val = roll11;
				}
			}
		} else if (getSelectedOption().getXMLID().equals("TWOROLLS")) {
			if ((type == RequiresSkillRoll.skillType)
					&& (type2 == RequiresSkillRoll.skillType)) {
				return val;
			} else {
				return val + backgroundSkill;
			}
		}
		return val;
	}

	/**
	 * If roll is based on a Characteristic, this returns the selected
	 * Characteristic.
	 * 
	 * @return
	 */
	public int getCharacteristic() {
		return characteristic;
	}

	/**
	 * If 2 rolls are required, both of them on Characteristics, this returns
	 * the second selected Characteristic.
	 * 
	 * @return
	 */
	public int getCharacteristic2() {
		return characteristic2;
	}

	public String getColumn2Output() {
		if (HeroDesigner.getActiveTemplate().is6E()) {
			String adderString = "";
			String ret = "";
			ret += getAlias();
			double val = getTotalValue();
			for (Adder ad : getAssignedAdders()) {
				if (adderString.length() > 0) {
					adderString += ", ";
				}
				adderString += ad.getAlias();
			}
			if ((getInput() != null) && (getInput().trim().length() > 0)) {
				if (ret.trim().length() > 0) {
					ret += ":  ";
				}
				ret += getInput();
			}
			for (Modifier mod : getAssignedModifiers()) {
				ret += ", " + mod.getAlias();
			}
			ret += " (";
			ret += getSelectedOption().getAlias()+"; ";
			if (adderString.trim().length() > 0) {
				ret += adderString + "; ";
			}
			if (getComments().trim().length() > 0) {
				ret += getComments() + "; ";
			}
			ret += getFraction(val) + ")";
			return ret;
		} else {
			String adderString = "";
			String ret = "";
			ret += getAlias();
			double val = getTotalValue();
			for (Adder ad : getAssignedAdders()) {
				if (adderString.length() > 0) {
					adderString += ", ";
				}
				adderString += ad.getAlias();
			}
			if ((getInput() != null) && (getInput().trim().length() > 0)) {
				if (ret.trim().length() > 0) {
					ret += ":  ";
				}
				ret += getInput();
			}
			for (Modifier mod : getAssignedModifiers()) {
				ret += ", " + mod.getAlias();
			}
			ret += " (";
			if (adderString.trim().length() > 0) {
				ret += adderString + "; ";
			}
			if (getComments().trim().length() > 0) {
				ret += getComments() + "; ";
			}
			ret += getFraction(val) + ")";
			return ret;
		}
	}

	public ModifierDialog getDialog(GenericObject parent, boolean isNew) {
		if (HeroDesigner.getActiveTemplate().is6E())
			return new ModifierDialog(this, isNew, parent);
		return new RequiresSkillRollDialog(this, isNew, parent);
	}

	/**
	 * Returns the user's name for the second roll (if present)
	 * 
	 * @return
	 */
	public String getRoll2Alias() {
		if (rollAlias2 == null) {
			rollAlias2 = "Skill";
		}
		return rollAlias2;
	}

	private double getRollAdjustment(int roll) {
		if (roll <= 8) {
			return roll8;
		} else if (roll <= 9) {
			return roll9;
		} else if (roll <= 10) {
			return roll10;
		} else if (roll <= 11) {
			return roll11;
		} else if (roll <= 12) {
			return roll12;
		} else if (roll <= 13) {
			return roll13;
		} else if (roll <= 14) {
			return roll14;
		} else {
			return roll15;
		}
	}

	/**
	 * Returns the user's text for the required roll.
	 * 
	 * @return
	 */
	public String getRollAlias() {
		if (rollAlias == null) {
			rollAlias = "Skill";
		}
		return rollAlias;
	}

	public Element getSaveXML() {
		Element root = super.getSaveXML();
		if (getSelectedOption() == null) {
			
		}
		else if (getSelectedOption().getXMLID().equals("BASICRSR")) {
			root.setAttribute("TYPE", "" + type);
			if (type == RequiresSkillRoll.charType) {
				root.setAttribute("CHARACTERISTIC", "" + characteristic);
			}
			root.setAttribute("ROLLALIAS", rollAlias);
		} else if (getSelectedOption().getXMLID().equals("TWOROLLS")) {
			root.setAttribute("TYPE", "" + type);
			root.setAttribute("TYPE2", "" + type2);
			if (type == RequiresSkillRoll.charType) {
				root.setAttribute("CHARACTERISTIC", "" + characteristic);
			}
			if (type2 == RequiresSkillRoll.charType) {
				root.setAttribute("CHARACTERISTIC2", "" + characteristic2);
			}
			root.setAttribute("ROLLALIAS", rollAlias);
			root.setAttribute("ROLLALIAS2", rollAlias2);
		} else {
			// nothing else required
		}
		return root;
	}

	/**
	 * Returns the type of RSR this is (Background, Skill, Characteristic, Luck)
	 * 
	 * @return
	 */
	public int getType() {
		if ((type < 0) || (type > 3)) {
			type = 0;
		}
		return type;
	}

	/**
	 * Returns the type of the second roll (if necessary).
	 * 
	 * @return
	 */
	public int getType2() {
		if ((type2 < 0) || (type2 > 3)) {
			type2 = 0;
		}
		return type2;
	}

	protected void init(Element element) {
		backgroundSkill = .25;
		roll8 = -2;
		roll9 = -1.5;
		roll10 = -1.25;
		roll11 = -1;
		roll12 = -.75;
		roll13 = -.75;
		roll14 = -.5;
		roll15 = -.25;
		rollAlias = "Skill";
		type = RequiresSkillRoll.skillType;
		type2 = RequiresSkillRoll.skillType;
		super.init(element);
		String check = XMLUtility.getValue(element, "BACKGROUNDSKILL");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				backgroundSkill = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}

		check = XMLUtility.getValue(element, "ROLL8");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll8 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "ROLL9");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll9 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "ROLL10");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll10 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "ROLL11");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll11 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "ROLL12");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll12 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "ROLL13");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll13 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "ROLL14");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll14 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "ROLL15");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				roll15 = Double.parseDouble(check);
			} catch (NumberFormatException ex) {
			}
		}
	}

	public boolean refreshAddersOnUpdate() {
		boolean ret = refreshOnUpdate;
		refreshOnUpdate = false;
		return ret;
	}

	public void restoreFromSave(Element root) {
		super.restoreFromSave(root);
		if (getSelectedOption() == null) {
			
		}
		else if (getSelectedOption().getXMLID().equals("BASICRSR")) {
			String check = XMLUtility.getValue(root, "TYPE");
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					type = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = XMLUtility.getValue(root, "CHARACTERISTIC");
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					characteristic = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = XMLUtility.getValue(root, "ROLLALIAS");
			if ((check != null) && (check.trim().length() > 0)) {
				rollAlias = check;
			} else if (type == RequiresSkillRoll.skillType) {
				rollAlias = "Skill";
			} else if (type == RequiresSkillRoll.backgroundType) {
				rollAlias = "Background Skill";
			} else if (type == RequiresSkillRoll.perType) {
				rollAlias = "PER";
			} else if (type == RequiresSkillRoll.charType) {
				rollAlias = "Characteristic";
			}
		} else if (getSelectedOption().getXMLID().equals("TWOROLLS")) {
			String check = XMLUtility.getValue(root, "TYPE");
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					type = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = XMLUtility.getValue(root, "CHARACTERISTIC");
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					characteristic = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = XMLUtility.getValue(root, "ROLLALIAS");
			if ((check != null) && (check.trim().length() > 0)) {
				rollAlias = check;
			} else if (type == RequiresSkillRoll.skillType) {
				rollAlias = "Skill";
			} else if (type == RequiresSkillRoll.backgroundType) {
				rollAlias = "Background Skill";
			} else if (type == RequiresSkillRoll.perType) {
				rollAlias = "PER";
			} else if (type == RequiresSkillRoll.charType) {
				rollAlias = "Characteristic";
			}
			check = XMLUtility.getValue(root, "TYPE2");
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					type2 = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = XMLUtility.getValue(root, "CHARACTERISTIC2");
			if ((check != null) && (check.trim().length() > 0)) {
				try {
					characteristic2 = Integer.parseInt(check);
				} catch (NumberFormatException ex) {
				}
			}
			check = XMLUtility.getValue(root, "ROLLALIAS2");
			if ((check != null) && (check.trim().length() > 0)) {
				rollAlias2 = check;
			} else if (type2 == RequiresSkillRoll.skillType) {
				rollAlias2 = "Skill";
			} else if (type2 == RequiresSkillRoll.backgroundType) {
				rollAlias2 = "Background Skill";
			} else if (type2 == RequiresSkillRoll.perType) {
				rollAlias2 = "PER";
			} else if (type2 == RequiresSkillRoll.charType) {
				rollAlias2 = "Characteristic";
			}
		} else {
		}
		// special bit here....since we've reset the alias by calling
		// setSelectedOption...
		String check = XMLUtility.getValue(root, "ALIAS");
		if ((check != null) && (check.trim().length() > 0)) {
			setAlias(check);
		}
	}

	/**
	 * Sets the Characteristic to base the first roll off of.
	 * 
	 * @see com.hero.util.Constants
	 * @param val
	 */
	public void setCharacteristic(int val) {
		characteristic = val;
	}

	/**
	 * Sets the Characteristic to base the second roll off of (if necessary)
	 * 
	 * @see com.hero.util.Constants
	 * @param val
	 */
	public void setCharacteristic2(int val) {
		characteristic2 = val;
	}

	public void setRefreshAddersOnUpdate(boolean val) {
		refreshOnUpdate = val;
	}

	/**
	 * Sets the user's text for the second roll.
	 * 
	 * @param val
	 */
	public synchronized void setRoll2Alias(String val) {
		String oldRoll = " " + rollAlias2.trim() + " ";
		if (oldRoll.trim().length() == 0) {
			oldRoll = null;
		}
		rollAlias2 = val;
		if ((oldRoll != null) && (getAlias().indexOf(getRollAlias()) >= 0)) {
			String part1 = getAlias().substring(0,
					getAlias().indexOf(getRollAlias()));
			if (!(part1.trim().toLowerCase().endsWith("a") || part1.trim()
					.toLowerCase().endsWith("an"))) {
				part1 = part1.trim() + " a ";
			}
			String part2 = getAlias().substring(
					getAlias().indexOf(getRollAlias())
							+ getRollAlias().length(), getAlias().length());
			String part3 = "";
			if ((getSelectedOption() != null)
					&& getSelectedOption().getXMLID().equals("TWOROLLS")) {
				if (getAlias().lastIndexOf(oldRoll) > getAlias().indexOf(
						getRollAlias())) {
					part2 = getAlias().substring(
							getAlias().indexOf(getRollAlias())
									+ getRollAlias().length(),
							getAlias().lastIndexOf(oldRoll));
					if (!(part2.trim().toLowerCase().endsWith("a") || part2
							.trim().toLowerCase().endsWith("an"))) {
						part2 = part2.trim() + " a ";
					}
					part3 = getAlias().substring(
							getAlias().lastIndexOf(oldRoll) + oldRoll.length(),
							getAlias().length());
					part3 = " " + rollAlias2.trim() + " " + part3.trim();
					// check for a/an:
					char first = rollAlias2.trim().toUpperCase().charAt(0);
					if (rollAlias2.trim().toLowerCase().startsWith("a ")
							|| rollAlias2.trim().toLowerCase()
									.startsWith("an ")) {
						part2 = part2.substring(0, part2.toLowerCase()
								.lastIndexOf("a"));
					} else if (part2.trim().toUpperCase().endsWith("N")
							&& !((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						part2 = part2.substring(0, part2.toUpperCase()
								.lastIndexOf("N"));
						String space = "";
						if (part2.startsWith(" ")) {
							space = " ";
						}
						part2 = part2.trim();
						part2 = space + part2;
					} else if (part2.trim().toUpperCase().endsWith("A")
							&& ((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						String space = "";
						if (part2.startsWith(" ")) {
							space = " ";
						}
						part2 = part2.trim();
						part2 = space + part2 + "n";
					}
				} else if (getAlias().lastIndexOf(oldRoll) >= 0) {
					part1 = getAlias().substring(0,
							getAlias().lastIndexOf(oldRoll));
					// check for a/an:
					char first = rollAlias2.trim().toUpperCase().charAt(0);
					if (rollAlias2.trim().toLowerCase().startsWith("a ")
							|| rollAlias2.trim().toLowerCase()
									.startsWith("an ")) {
						part1 = part1.substring(0, part1.toLowerCase()
								.lastIndexOf("a"));
					} else if (part1.trim().toUpperCase().endsWith("N")
							&& !((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						part1 = part1.substring(0, part1.toUpperCase()
								.lastIndexOf("N"));
						String space = "";
						if (part1.startsWith(" ")) {
							space = " ";
						}
						part1 = part1.trim();
						part1 = space + part1;
					} else if (part1.trim().toUpperCase().endsWith("A")
							&& ((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						String space = "";
						if (part1.startsWith(" ")) {
							space = " ";
						}
						part1 = part1.trim();
						part1 = space + part1 + "n";
					}
					part1 += " " + rollAlias2.trim() + " ";
					part2 = getAlias().substring(
							getAlias().lastIndexOf(oldRoll) + oldRoll.length(),
							getAlias().indexOf(getRollAlias()));
					part3 = getAlias().substring(
							getAlias().indexOf(getRollAlias())
									+ getRollAlias().length(),
							getAlias().length());
				}
			}
			char first = getRollAlias().trim().toUpperCase().charAt(0);
			if (getRollAlias().trim().toLowerCase().startsWith("a ")
					|| getRollAlias().trim().toLowerCase().startsWith("an ")) {
				part1 = part1
						.substring(0, part1.toLowerCase().lastIndexOf("a"));
			} else if (part1.trim().toUpperCase().endsWith("N")
					&& !((first == 'A') || (first == 'E') || (first == 'I')
							|| (first == 'O') || (first == 'U')
							|| (first == 'Y') || (first == 'H'))) {
				part1 = part1
						.substring(0, part1.toUpperCase().lastIndexOf("N"));
				String space = "";
				if (part1.startsWith(" ")) {
					space = " ";
				}
				part1 = part1.trim();
				part1 = space + part1 + "n";
			} else if (part1.trim().toUpperCase().endsWith("A")
					&& ((first == 'A') || (first == 'E') || (first == 'I')
							|| (first == 'O') || (first == 'U')
							|| (first == 'Y') || (first == 'H'))) {
				String space = "";
				if (part1.startsWith(" ")) {
					space = " ";
				}
				part1 = part1.trim();
				part1 = space + part1 + "n";
			}
			setAlias(part1.trim() + " " + getRollAlias().trim() + " "
					+ part2.trim() + " " + part3.trim());
		}
	}

	/**
	 * Sets the user's text for the primary roll.
	 * 
	 * @param val
	 */
	public synchronized void setRollAlias(String val) {
		String oldRoll = rollAlias;
		oldRoll = " " + oldRoll.trim() + " ";
		if (oldRoll.trim().length() == 0) {
			oldRoll = null;
		}
		rollAlias = val;
		if ((oldRoll != null) && (getAlias().indexOf(oldRoll) >= 0)) {
			String part1 = getAlias().substring(0, getAlias().indexOf(oldRoll));
			if (!(part1.trim().toLowerCase().endsWith("a") || part1.trim()
					.toLowerCase().endsWith("an"))) {
				part1 = part1.trim() + " a ";
			}
			String part2 = getAlias().substring(
					getAlias().indexOf(oldRoll) + oldRoll.length(),
					getAlias().length());
			String part3 = "";
			if ((getSelectedOption() != null)
					&& getSelectedOption().getXMLID().equals("TWOROLLS")) {
				if (getAlias().indexOf(getRoll2Alias(),
						getAlias().indexOf(oldRoll) + oldRoll.length()) > 0) {
					part2 = getAlias().substring(
							getAlias().indexOf(oldRoll) + oldRoll.length(),
							getAlias().indexOf(
									getRoll2Alias(),
									getAlias().indexOf(oldRoll)
											+ oldRoll.length()));
					if (!(part2.trim().toLowerCase().endsWith("a") || part2
							.trim().toLowerCase().endsWith("an"))) {
						part2 = part2.trim() + " a ";
					}
					part3 = getAlias().substring(
							getAlias().indexOf(
									getRoll2Alias(),
									getAlias().indexOf(oldRoll)
											+ oldRoll.length())
									+ getRoll2Alias().length(),
							getAlias().length());
					part3 = " " + getRoll2Alias() + " " + part3;
					// check for a/an:
					char first = getRoll2Alias().trim().toUpperCase().charAt(0);
					if (getRoll2Alias().trim().toLowerCase().startsWith("a ")
							|| getRoll2Alias().trim().toLowerCase().startsWith(
									"an ")) {
						part2 = part2.substring(0, part2.toLowerCase()
								.lastIndexOf("a"));
					}
					if (part2.trim().toUpperCase().endsWith("N")
							&& !((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						part2 = part2.substring(0, part2.toUpperCase()
								.lastIndexOf("N"));
					} else if (part2.trim().toUpperCase().endsWith("A")
							&& ((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						String space = "";
						if (part2.startsWith(" ")) {
							space = " ";
						}
						part2 = part2.trim();
						part2 = space + part2 + "n";
					}
				} else if (getAlias().indexOf(getRoll2Alias()) >= 0) {
					part1 = getAlias().substring(0,
							getAlias().indexOf(getRoll2Alias()));
					char first = getRoll2Alias().trim().toUpperCase().charAt(0);
					if (getRoll2Alias().trim().toLowerCase().startsWith("a ")
							|| getRoll2Alias().trim().toLowerCase().startsWith(
									"an ")) {
						part1 = part1.substring(0, part1.toLowerCase()
								.lastIndexOf("a"));
					} else if (part1.trim().toUpperCase().endsWith("N")
							&& !((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						part1 = part1.substring(0, part1.toUpperCase()
								.lastIndexOf("N"));
					} else if (part1.trim().toUpperCase().endsWith("A")
							&& ((first == 'A') || (first == 'E')
									|| (first == 'I') || (first == 'O')
									|| (first == 'U') || (first == 'Y') || (first == 'H'))) {
						String space = "";
						if (part1.startsWith(" ")) {
							space = " ";
						}
						part1 = part1.trim();
						part1 = space + part1 + "n";
					}
					part1 += getRoll2Alias();
					part2 = getAlias().substring(
							getAlias().indexOf(getRoll2Alias())
									+ getRoll2Alias().length(),
							getAlias().indexOf(oldRoll));
					part3 = getAlias().substring(
							getAlias().indexOf(oldRoll) + oldRoll.length(),
							getAlias().length());
				}
			}
			char first = rollAlias.trim().toUpperCase().charAt(0);
			if (rollAlias.trim().toLowerCase().startsWith("a ")
					|| rollAlias.trim().toLowerCase().startsWith("an ")) {
				part1 = part1
						.substring(0, part1.toLowerCase().lastIndexOf("a"));
			} else if (part1.trim().toUpperCase().endsWith("N")
					&& !((first == 'A') || (first == 'E') || (first == 'I')
							|| (first == 'O') || (first == 'U')
							|| (first == 'Y') || (first == 'H'))) {
				part1 = part1
						.substring(0, part1.toUpperCase().lastIndexOf("N"));
			} else if (part1.trim().toUpperCase().endsWith("A")
					&& ((first == 'A') || (first == 'E') || (first == 'I')
							|| (first == 'O') || (first == 'U')
							|| (first == 'Y') || (first == 'H'))) {
				String space = "";
				if (part1.startsWith(" ")) {
					space = " ";
				}
				part1 = part1.trim();
				part1 = space + part1 + "n";
			}
			setAlias(part1.trim() + " " + rollAlias.trim() + " " + part2.trim()
					+ " " + part3.trim());
			if ((getSelectedOption() != null)
					&& getSelectedOption().getXMLID().equals("TWOROLLS")) {
				setRoll2Alias(getRoll2Alias());
			}
		}
	}

	public void setSelectedOption(Adder option) {
		Adder origOption = getSelectedOption();
		super.setSelectedOption(option);
		if (HeroDesigner.getActiveTemplate().is6E()) {
			return;
		}
		if (option != null) {
			baseCost = option.getBaseCost();
			if ((origOption != null)
					&& (option.getXMLID() == origOption.getXMLID())) {
				return;
			}
			if (getAlias().startsWith("Requires")) {
				if (option.getXMLID().equals("ONELUCK")) {
					setAlias("Requires A Luck Roll");
				} else if (option.getXMLID().equals("TWOLUCK")) {
					setAlias("Requires Two Levels of Luck");
				} else if (option.getXMLID().equals("THREELUCK")) {
					setAlias("Requires Three Levels of Luck");
				} else if (option.getXMLID().equals("TWOROLLS")) {
					setAlias("Requires A " + getRollAlias() + " Roll And A "
							+ getRoll2Alias() + " Roll");
				} else {
					setAlias("Requires A " + getRollAlias() + " Roll");
				}
			}
		}
	}

	/**
	 * Sets the type of the primary roll (Background, Skill, Characteristic,
	 * Luck)
	 * 
	 * @param type
	 */
	public void setType(int type) {
		this.type = type;
	}

	/**
	 * Sets the type of the secondary roll (Background, Skill, Characteristic,
	 * Luck)
	 * 
	 * @param typ2
	 */
	public void setType2(int typ2) {
		type2 = typ2;
	}
}